<?php

use Illuminate\Support\Facades\Route;
use App\Services\SafeHavenService;
use App\Models\SafeHavenTransferToken;

Route::get('/', function () {
    return view('welcome');
});


Route::get("get-safe-haven-token", function() {
    $token = (new SafeHavenService())->cronToken();
    if($token != null) {
        try {
            SafeHavenTransferToken::create(
                [
                    "token" => $token["access_token"],
                    "data_response" => json_encode($token)
                ]
            );
        } catch (\Throwable $th) {
            // throw $th;
        }

    }
    return $token["access_token"];
});
