<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_conversations', function (Blueprint $table) {
            $table->id();
            $table->string('booking_id')->nullable();
            $table->string('member_id')->nullable();
            $table->string('role')->nullable();
            $table->longText('content')->nullable();
            $table->longText('file_content')->nullable();
            $table->longText('files')->nullable();
            $table->string('system_type')->nullable();
            $table->longText('message')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_conversations');
    }
};
