<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subscription extends Model
{
    const PAID = true;
    const UNPAID = false;
    use HasFactory;

    protected $fillable = [
        'member_id',
        'reference',
        'amount',
        'duration',
        'start_date',
        'end_date',
        'active'
    ];

    public function member()
    {
        return $this->belongsTo(User::class, 'member_id');
    }
}
