<?php

namespace App\Models;

use Carbon\Carbon;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Member extends Authenticatable implements JWTSubject
{
    use Notifiable;
    protected $table = "members";
    protected $guarded = [];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function tokenTransactions()
    {
        return $this->hasMany(TokenTransaction::class);
    }


    public function hasActiveSubscription()
{
    return $this->next_subscription_date && Carbon::parse($this->next_subscription_date)->isFuture();
}


}
