<?php

namespace App\Http\Controllers;

use App\Models\AICharater;
use App\Models\Chat;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ChatController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $chatai = AICharater::first();
        $chat = Chat::where("member_id", auth("member")->user()->member_id)->first();
        if ($chat == null) {
            $newchat = Chat::create([
                "member_id" => auth("member")->user()->member_id,
                "role" => "system",
                "content" => $chatai->charater_prompt
            ]);
        }
        if ($chat != null) {
            $chat->update([
                "content" => $chatai->charater_prompt
            ]);
        }
        $chats = $this->getChats();
        return response()->json(["message" => "success", "chats" => $chats], 200);
    }

    protected function getChats() {
        $chats = Chat::where("member_id", auth("member")->user()->member_id)->select(["role", "content", "created_at"])->get();
        return $chats;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // $chats = Chat::where("member_id", auth("member")->user()->member_id)->get()->toArray();
        $request->validate([
            "message" => "required|string",
        ]);
        $newcaht = Chat::create([
            "role" => "user",
            "member_id" => auth("member")->user()->member_id,
            "content" => $request->message
        ]);
        $chats = $this->getChats();

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . env('DEEPSEEK_API_KEY'), // 🔑 Put this in .env
            'Content-Type' => 'application/json',
        ])
        ->post('https://api.deepseek.com/v1/chat/completions', [
            "model" => "deepseek-chat",
            "messages" => $chats,
            // "temperature" => 1.5,
            "stream" => false
        ]);

// return $response->json()["choices"][0]["message"];
        $newcahtai = Chat::create([
            "role" => "assistant",
            "content" => $response->json()["choices"][0]["message"]["content"],
            "member_id" => auth("member")->user()->member_id
        ]);
        $chats = $this->getChats();
        return response()->json(["message" => "success", "chats" => $chats, "dd" => $response->json()["choices"][0]["message"]], 200);
    }



    /**
     * Display the specified resource.
     */
    public function show(Chat $chat)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Chat $chat)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Chat $chat)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Chat $chat)
    {
        //
    }
}
